/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.preprocessor;

import com.inprise.vbroker.compiler.preprocessor.ConditionalInfo;
import com.inprise.vbroker.compiler.preprocessor.ConstExprParserWrapper;
import com.inprise.vbroker.compiler.preprocessor.FunctionalMacro;
import com.inprise.vbroker.compiler.preprocessor.IDLppOptions;
import com.inprise.vbroker.compiler.preprocessor.Macro;
import com.inprise.vbroker.compiler.preprocessor.OpenStream;
import com.inprise.vbroker.compiler.preprocessor.SimpleMacro;
import com.inprise.vbroker.compiler.util.BufferReader;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.Utils;
import com.inprise.vbroker.util.LexicalTables;
import com.inprise.vbroker.util.SimpleStringBuffer;
import com.inprise.vbroker.util.StringFunctions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public final class IDLpp
implements LexicalTables {
    private static final boolean Debug = false;
    private static final boolean Trace = false;
    private static final boolean Timing = false;
    private static final String _lineSeparator = System.getProperty("line.separator");
    private String CurrentWorkingDirectory;
    private String _sysInclLoc;
    String LineSeparator;
    byte FirstLineSeparatorChar;
    int LineSeparatorLength;
    private ErrorReporter ER;
    private OpenStream Input;
    private long InputDepth = 0L;
    private long SavedInputDepth = -1L;
    private BufferReader Reader;
    private Sink Out;
    private Sink PreviousSink;
    private Sink NormalSink;
    private Sink OneLineSink = new Sink();
    private Sink MacroArgSink = new Sink();
    private boolean GenerateOutput = true;
    private boolean GenerateLineDirectives = true;
    private boolean NotifyInclusions = false;
    private boolean RetainComments = false;
    private boolean RetainLineDirectives = true;
    private boolean ShowAllLines = false;
    private Vector IncludePaths = new Vector();
    private long PendingOutputNewlines = 0L;
    private long LastErrorCharLineNumber = -1L;
    private final Hashtable MacroTable = new Hashtable(128);
    final boolean[] MacroHitTable = new boolean[256];
    FunctionalMacro BuiltinDefinedMacro;
    private boolean SubstituteMacros = true;
    private int Mode = 0;
    private static final int NORMAL_MODE = 0;
    private static final int GATHERING_MACRO_ARGS_MODE = 1;
    private static final int READING_MACRO_BODY_MODE = 2;
    private FunctionalMacro CurrentMacro;
    private Vector MacroArgs = new Vector();
    private int ParenNestingLevel;
    private StringBuffer StrBuf = new StringBuffer(128);
    private final ConstExprParserWrapper ConstParser = new ConstExprParserWrapper();
    private Vector TopLevelIncludedFiles;
    private IDLppOptions _options;

    public IDLpp(String inputStreamDirectory, InputStream inputStream, OutputStream outputStream, IDLppOptions options, BufferReader reader, Vector topLevelIncludedFiles) {
        this.LineSeparator = System.getProperty("line.separator");
        this.LineSeparatorLength = this.LineSeparator.length();
        this.FirstLineSeparatorChar = (byte)this.LineSeparator.charAt(0);
        this._options = options;
        this.ER = options._ER;
        this.Reader = reader;
        this.TopLevelIncludedFiles = topLevelIncludedFiles;
        this.CurrentWorkingDirectory = System.getProperty("user.dir");
        String sysInclLoc = System.getProperty("vbroker.installDir");
        if (sysInclLoc != null) {
            this._sysInclLoc = Utils.canonicalize(String.valueOf(new StringBuffer(String.valueOf(sysInclLoc)).append(File.separatorChar).append("idl")));
        }
        try {
            this.Input = new OpenStream(inputStream, "", inputStreamDirectory, -1);
            this.Out = this.NormalSink = new Sink(outputStream);
        }
        catch (IOException e) {
            this.ER.internalError("unable to read from bootstrap stream");
        }
    }

    private void EOFCleanup() throws IOException {
        if (this.Mode == 1) {
            this.stopMacroArgs();
            this.error("MacroUse.EOF", this.CurrentMacro.name());
            this.CurrentMacro = null;
        }
        this.LastErrorCharLineNumber = -1L;
        this.Mode = 0;
        this.SubstituteMacros = true;
        this.PendingOutputNewlines = 0L;
    }

    public static Result VisiBrokerPreprocess(IDLppOptions options, String fileName, BufferReader reader, Vector topLevelIncludedFiles) {
        ErrorReporter ER = options._ER;
        boolean savedSetting = ER._multipleMessagesPerLine;
        ER._multipleMessagesPerLine = true;
        String sysInclLoc = System.getProperty("vbroker.installDir");
        if (sysInclLoc != null) {
            sysInclLoc = Utils.canonicalize(String.valueOf(new StringBuffer(String.valueOf(sysInclLoc)).append(File.separatorChar).append("idl")));
            options._includes.insertElementAt(sysInclLoc, 0);
        }
        Vector<String> files = new Vector<String>();
        files.addElement(fileName);
        Result result = IDLpp.preprocessToString(options, files, reader, topLevelIncludedFiles);
        ER._multipleMessagesPerLine = savedSetting;
        return result;
    }

    private void _newLine() throws IOException {
        for (int i = 0; i < this.LineSeparatorLength; ++i) {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = (byte)this.LineSeparator.charAt(i);
        }
    }

    private String builtinFunctionalMacro(String opName, Vector args) {
        if (opName.equals("defined")) {
            if (args.size() != 1) {
                this.error("MacroUse.argNumberMismatch", "defined");
                return "0L";
            }
            String identName = (String)args.elementAt(0);
            String ret = this.MacroTable.get(identName) == null ? "0L" : "1L";
            return ret;
        }
        this.ER.internalError("unknown builtin macro name ".concat(String.valueOf(opName)));
        return null;
    }

    private String builtinSimpleMacro(String opName) {
        if (opName.equals("__LINE__")) {
            return "".concat(String.valueOf(this.Input.LineNumber));
        }
        if (opName.equals("__FILE__")) {
            return String.valueOf(new StringBuffer("\"").append(this.Input.FileName).append("\""));
        }
        if (opName.equals("__DATE__")) {
            return this.getDateAsLiteralString();
        }
        if (opName.equals("__TIME__")) {
            return this.getTimeAsLiteralString();
        }
        this.ER.internalError("unknown builtin macro name ".concat(String.valueOf(opName)));
        return null;
    }

    private boolean cleanupNewline() throws IOException {
        if (this.Input.Index == this.Input.Length && !this.reload()) {
            return false;
        }
        if (this.startsLineSep(this.Input.Buffer[this.Input.Index])) {
            this.processNewline(false);
            return true;
        }
        return false;
    }

    private byte[] collectAndProcessUntilNewline(boolean substituteMacros, String textToAppend) throws IOException {
        String rawBody = String.valueOf(this.gatherUntilNewline()).concat(String.valueOf(textToAppend));
        if (rawBody.length() == 0) {
            return new byte[0];
        }
        this.startLineGather();
        if (!substituteMacros) {
            this.SubstituteMacros = false;
        }
        OpenStream savedInput = this.Input;
        this.Input = new OpenStream(rawBody.getBytes("8859_1"), this.Input, null);
        this.process();
        this.Input = savedInput;
        byte[] ret = this.Out.toByteArray();
        this.stopLineGather();
        if (!substituteMacros) {
            this.SubstituteMacros = true;
        }
        return ret;
    }

    private void createFunctionalMacro(String name) throws IOException {
        String errMesg;
        this.gatherFormalArgs();
        this.CurrentMacro = new FunctionalMacro(name, this.Input.FileName, this.Input.LineNumber, this.MacroArgs.size(), false);
        this.Mode = 2;
        String finalPiece = this.stringCopyOfProcessedTextUntilNewline(true).trim();
        if (!finalPiece.equals("") && (errMesg = this.CurrentMacro.addLiteralString(finalPiece)) != null) {
            this.error(errMesg);
        }
        if ((errMesg = this.CurrentMacro.finishDefinition()) != null) {
            this.error(errMesg);
        }
        this.Mode = 0;
        this.installMacro(this.CurrentMacro, true);
    }

    private void createSimpleMacro(String name) throws IOException {
        byte[] macroBody = this.collectAndProcessUntilNewline(false, " ");
        this.installMacro(new SimpleMacro(name, this.Input.FileName, this.Input.LineNumber, macroBody), true);
    }

    private boolean directiveError(String mesgName) {
        return this.ER.error("Comp.PP.Directive.".concat(String.valueOf(mesgName)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber);
    }

    private boolean directiveError(String mesgName, String arg) {
        return this.ER.error("Comp.PP.Directive.".concat(String.valueOf(mesgName)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, arg);
    }

    private boolean directiveWarn(String mesgName) {
        return this.ER.warn("Comp.PP.Directive.".concat(String.valueOf(mesgName)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber);
    }

    private boolean directiveWarn(String mesgName, String arg) {
        return this.ER.warn("Comp.PP.Directive.".concat(String.valueOf(mesgName)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, arg);
    }

    private boolean directiveWarn(String mesgName, String refName, long previousLineNumber) {
        return this.ER.warn2("Comp.PP.Directive.".concat(String.valueOf(mesgName)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, "Comp.PP.Directive.".concat(String.valueOf(refName)), this.ER.setFile(this.Input.FileName), previousLineNumber);
    }

    private boolean eliminateLineContinuation() throws IOException {
        if (this.Input.advance() && this.startsLineSep(this.Input.Buffer[this.Input.Index])) {
            this.processNewline(true);
            return true;
        }
        return false;
    }

    private boolean error(String mesg) {
        return this.ER.error("Comp.PP.".concat(String.valueOf(mesg)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber);
    }

    private boolean error(String mesg, String arg) {
        return this.ER.error("Comp.PP.".concat(String.valueOf(mesg)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, arg);
    }

    private String escChar(byte b) {
        return this.escChar((char)(b & 0xFF));
    }

    private String escChar(char chr) {
        return String.valueOf(new StringBuffer("'").append(StringFunctions.ISOLatin1CharToPrintable(chr, false)).append("'"));
    }

    public void execute() {
        this.initializeBuiltinMacros();
        try {
            this.process();
        }
        catch (IOException e) {
            if (this.SavedInputDepth > 100L) {
                this.ER.fatal("Comp.IOErrorMaybeInputDepth", new Object[]{new Long(this.SavedInputDepth)});
            }
            this.ER.fatal("Comp.IOError");
        }
    }

    private int f() throws IOException {
        this.Out.flush();
        return this.Out.I++;
    }

    String[] fileSpecToPathNames(String filespec) {
        String trimmedFileSpec = Utils.canonicalize(filespec.substring(1, filespec.length() - 1));
        if (new File(trimmedFileSpec).isAbsolute()) {
            return new String[]{trimmedFileSpec};
        }
        if (trimmedFileSpec.equals("-")) {
            return new String[]{null};
        }
        trimmedFileSpec = Utils.mapHyphenNames(trimmedFileSpec);
        String[] ret = new String[this.IncludePaths.size() + 1];
        ret[0] = this.Input.Directory.equals(this.CurrentWorkingDirectory) ? trimmedFileSpec : new File(this.Input.Directory, trimmedFileSpec).getAbsolutePath();
        for (int i = 0; i < this.IncludePaths.size(); ++i) {
            ret[i + 1] = String.valueOf(new StringBuffer(String.valueOf((String)this.IncludePaths.elementAt(i))).append(File.separatorChar).append(trimmedFileSpec));
        }
        return ret;
    }

    private String gatherErrorText() throws IOException {
        String ret = this.gatherUntilNewline().trim();
        this.cleanupNewline();
        return ret;
    }

    private void gatherFormalArgs() throws IOException {
        this.MacroArgs.setSize(0);
        String currentArg = null;
        boolean complainedAboutBadChar = false;
        boolean argExpected = false;
        ++this.Input.Index;
        while (true) {
            if (this.Input.Index == this.Input.Length && !this.reload()) {
                this.directiveError("define.formals.EOF");
                return;
            }
            byte chr = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[chr & 0xFF] == 1) {
                String name = this.gatherIdentifier();
                if (currentArg == null) {
                    currentArg = name;
                } else {
                    this.directiveError("define.formals.multiForm", name);
                }
                argExpected = false;
                continue;
            }
            if (LexicalTables.IDLCharClass[chr & 0xFF] == 0) {
                this.outputWhitespace();
                continue;
            }
            if (chr == 92) {
                if (this.eliminateLineContinuation()) continue;
                this.error("LonelyBackslash");
                continue;
            }
            if (chr == 41) {
                if (currentArg == null && argExpected) {
                    this.directiveWarn("define.formals.emptyArg");
                }
                if (currentArg != null) {
                    if (this.MacroArgs.contains(currentArg)) {
                        this.directiveError("define.formals.dupName", currentArg);
                    }
                    this.MacroArgs.addElement(currentArg);
                }
                ++this.Input.Index;
                return;
            }
            if (chr == 44) {
                if (currentArg == null) {
                    this.directiveWarn("define.formals.emptyArg");
                    currentArg = "";
                } else if (this.MacroArgs.contains(currentArg)) {
                    this.directiveError("define.formals.dupName", currentArg);
                }
                this.MacroArgs.addElement(currentArg);
                currentArg = null;
                argExpected = true;
                ++this.Input.Index;
                continue;
            }
            if (this.startsLineSep(chr)) {
                this.directiveError("define.formals.unterminated");
                return;
            }
            if (!complainedAboutBadChar) {
                complainedAboutBadChar = true;
                this.directiveError("define.formals.badChar", this.escChar(chr));
            }
            ++this.Input.Index;
        }
    }

    private String gatherIdentifier() throws IOException {
        this.StrBuf.setLength(0);
        this.StrBuf.append((char)(this.Input.Buffer[this.Input.Index] & 0xFF));
        ++this.Input.Index;
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte chr = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[chr & 0xFF] == 1 || LexicalTables.IDLCharClass[chr & 0xFF] == 2) {
                this.StrBuf.append((char)(chr & 0xFF));
                ++this.Input.Index;
                continue;
            }
            if (chr != 92) break;
            if (this.eliminateLineContinuation()) continue;
            this.error("LonelyBackslash");
            break;
        }
        return this.StrBuf.toString();
    }

    private String gatherUntilNewline() throws IOException {
        this.StrBuf.setLength(0);
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte chr = this.Input.Buffer[this.Input.Index];
            if (chr == 92) {
                if (this.eliminateLineContinuation()) continue;
                this.StrBuf.append((char)(chr & 0xFF));
                continue;
            }
            if (this.startsLineSep(chr)) {
                return this.StrBuf.toString();
            }
            this.StrBuf.append((char)(chr & 0xFF));
            ++this.Input.Index;
        }
        return this.StrBuf.toString();
    }

    private String getDateAsLiteralString() {
        String ret = "\"";
        SimpleDateFormat monthFormat = new SimpleDateFormat("MMM");
        SimpleDateFormat dayFormat = new SimpleDateFormat("dd");
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        Date today = new Date();
        String month = monthFormat.format(today);
        String day = dayFormat.format(today);
        String year = yearFormat.format(today);
        if (day.charAt(0) == '0') {
            day = " ".concat(String.valueOf(day.charAt(1)));
        }
        return String.valueOf(new StringBuffer(String.valueOf(ret)).append(month).append(" ").append(day).append(" ").append(year).append("\""));
    }

    private String getTimeAsLiteralString() {
        return String.valueOf(new StringBuffer("\"").append(new SimpleDateFormat("HH:mm:ss").format(new Date())).append("\""));
    }

    private void handleDirective() throws IOException {
        block27: {
            byte chr;
            block28: {
                while (true) {
                    if (this.Input.Index == this.Input.Length && !this.reload()) {
                        return;
                    }
                    chr = this.Input.Buffer[this.Input.Index];
                    if (LexicalTables.IDLCharClass[chr & 0xFF] == 0) {
                        this.outputWhitespace();
                        continue;
                    }
                    if (LexicalTables.IDLCharClass[chr & 0xFF] == 1) break block27;
                    if (chr != 92) break block28;
                    if (!this.eliminateLineContinuation()) break;
                }
                this.directiveError("lonelyBackslash1");
                return;
            }
            if (this.startsLineSep(chr)) {
                this.cleanupNewline();
            } else {
                this.directiveError("badPostScratchChar", this.escChar(chr));
                this.gatherErrorText();
            }
            return;
        }
        String directive = this.gatherIdentifier();
        if (directive.equals("include")) {
            this.processIncludeDirective();
            return;
        }
        if (directive.equals("define")) {
            this.processDefineDirective();
        } else if (directive.equals("if")) {
            this.processIfDirective();
        } else if (directive.equals("else")) {
            this.processElseDirective();
        } else if (directive.equals("endif")) {
            this.processEndIfDirective();
        } else if (directive.equals("ifdef")) {
            this.processIfDefDirective(false);
        } else if (directive.equals("ifndef")) {
            this.processIfDefDirective(true);
        } else if (directive.equals("undef")) {
            this.processUnDefDirective();
        } else {
            if (directive.equals("line")) {
                this.processLineDirective();
                return;
            }
            if (directive.equals("elif")) {
                this.processElIfDirective();
            } else if (directive.equals("error")) {
                this.processErrorDirective();
            } else if (directive.equals("pragma")) {
                this.processPragmaDirective();
            } else {
                this.directiveError("unknown", directive);
                this.gatherErrorText();
                return;
            }
        }
        this.cleanupNewline();
    }

    private void handleErrorChar(byte chr) throws IOException {
        int n;
        if (chr == 13 && this.FirstLineSeparatorChar != chr) {
            ++this.Input.Index;
            return;
        }
        if (this.Input.LineNumber != this.LastErrorCharLineNumber) {
            this.warn("BadChar", this.escChar(chr));
            this.LastErrorCharLineNumber = this.Input.LineNumber;
        }
        byte[] byArray = this.Out.Buf;
        if (this.Out.I < this.Out.Len) {
            int n2 = this.Out.I;
            n = n2;
            this.Out.I = n2 + 1;
        } else {
            n = this.f();
        }
        byArray[n] = chr;
        ++this.Input.Index;
    }

    private void initializeBuiltinMacros() {
        this.installMacro(new SimpleMacro("__DATE__"), false);
        this.installMacro(new SimpleMacro("__FILE__"), false);
        this.installMacro(new SimpleMacro("__LINE__"), false);
        this.installMacro(new SimpleMacro("__TIME__"), false);
        this.BuiltinDefinedMacro = new FunctionalMacro("defined", null, -1L, 1, true);
    }

    private boolean installMacro(Macro macro, boolean checkForDuplicates) {
        Macro existingMacro;
        String name = macro.name();
        if (checkForDuplicates && (existingMacro = (Macro)this.MacroTable.get(name)) != null) {
            if (existingMacro.isBuiltin()) {
                this.directiveError("define.builtin");
                return false;
            }
            if (existingMacro.equals(macro)) {
                return true;
            }
            if (this.directiveWarn("define.exists", name)) {
                if (existingMacro.fileName().equals(this.Input.FileName)) {
                    this.ER.add("Comp.PP.Directive.define.exists1", new Object[]{new Long(existingMacro.lineNumber())});
                } else {
                    this.ER.add("Comp.PP.Directive.define.exists2", new Object[]{this.prepFilename(existingMacro.fileName()), new Long(existingMacro.lineNumber())});
                }
            }
        }
        this.MacroTable.put(name, macro);
        byte b = (byte)name.charAt(0);
        this.MacroHitTable[b] = true;
        return true;
    }

    private void invokeMacro() throws IOException {
        String maybeFinalArg = this.Out.toString().trim();
        this.stopMacroArgs();
        if (this.MacroArgs.size() > 0 || maybeFinalArg.length() > 0) {
            this.MacroArgs.addElement(maybeFinalArg);
        }
        this.Mode = 0;
        this.SubstituteMacros = true;
        if (this.CurrentMacro.isBuiltin()) {
            String str = this.builtinFunctionalMacro(this.CurrentMacro.name(), this.MacroArgs);
            byte[] value = str.getBytes("8859_1");
            this.pushTemporaryInput(value, null);
        } else {
            this.MacroTable.remove(this.CurrentMacro.name());
            if (this.MacroArgs.size() != this.CurrentMacro.numArgs()) {
                this.error("MacroUse.argNumberMismatch", this.CurrentMacro.name());
            }
            this.pushTemporaryInput(this.CurrentMacro.value(this.MacroArgs), this.CurrentMacro);
        }
        this.CurrentMacro = null;
    }

    private static boolean isLegalIdent(String s) {
        if (s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
            int len = s.length();
            for (int i = 1; i < len; ++i) {
                c = s.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static ByteArrayInputStream makeBootstrapStream(IDLppOptions options, String source) {
        return IDLpp.makeBootstrapStreamWorker(options, source);
    }

    private static ByteArrayInputStream makeBootstrapStream(IDLppOptions options, Vector files) {
        SimpleStringBuffer buf = new SimpleStringBuffer();
        if (files == null) {
            buf.append("#include \"-\"".concat(String.valueOf(_lineSeparator)));
        } else {
            for (int i = 0; i < files.size(); ++i) {
                buf.append("#include \"");
                buf.append((String)files.elementAt(i));
                buf.append("\"".concat(String.valueOf(_lineSeparator)));
            }
        }
        return IDLpp.makeBootstrapStreamWorker(options, buf.toString());
    }

    private static ByteArrayInputStream makeBootstrapStreamWorker(IDLppOptions options, String endStuff) {
        int i;
        SimpleStringBuffer buf = new SimpleStringBuffer();
        buf.append("#line -2147483648".concat(String.valueOf(_lineSeparator)));
        Vector inclPaths = options._includes;
        int len = inclPaths == null ? 0 : inclPaths.size();
        for (i = 0; i < len; ++i) {
            buf.append("#pragma Inprise IDLpp appendToIncludePaths \"");
            buf.append((String)inclPaths.elementAt(i));
            buf.append("\"".concat(String.valueOf(_lineSeparator)));
        }
        if (!options._lineDirectives) {
            buf.append("#pragma Inprise IDLpp suppressLinePragmas");
            buf.append(_lineSeparator);
        }
        if (options._showInclusions) {
            buf.append("#pragma Inprise IDLpp showInclusions");
            buf.append(_lineSeparator);
        }
        if (options._retainComments) {
            buf.append("#pragma Inprise IDLpp retainComments");
            buf.append(_lineSeparator);
        }
        for (i = 0; i < options._defines.size(); ++i) {
            if (options._defOrUndef.elementAt(i) == Boolean.TRUE) {
                String s;
                String macroName = s = (String)options._defines.elementAt(i);
                String macroValue = "";
                if (s.indexOf(61) != -1) {
                    macroName = s.substring(0, s.indexOf(61));
                    macroValue = s.substring(s.indexOf(61) + 1, s.length());
                }
                buf.append("#ifdef ");
                buf.append(macroName);
                buf.append(String.valueOf(_lineSeparator).concat("#undef "));
                buf.append(macroName);
                buf.append(String.valueOf(new StringBuffer(String.valueOf(_lineSeparator)).append("#endif").append(_lineSeparator).append("#define ")));
                buf.append(macroName);
                buf.append(" ");
                buf.append(macroValue);
                buf.append(_lineSeparator);
                continue;
            }
            String macroName = (String)options._defines.elementAt(i);
            buf.append("#ifdef ");
            buf.append(macroName);
            buf.append(String.valueOf(_lineSeparator).concat("#undef "));
            buf.append(macroName);
            buf.append(String.valueOf(new StringBuffer(String.valueOf(_lineSeparator)).append("#endif").append(_lineSeparator)));
        }
        buf.append("#define __STD_IDL__ 1".concat(String.valueOf(_lineSeparator)));
        buf.append("#define __INPRISE__ 1".concat(String.valueOf(_lineSeparator)));
        buf.append("#define __MAJOR_VERSION__ 04".concat(String.valueOf(_lineSeparator)));
        buf.append("#define __MINOR_VERSION__ 00".concat(String.valueOf(_lineSeparator)));
        buf.append(endStuff);
        try {
            ByteArrayInputStream i2 = new ByteArrayInputStream(buf.toString().getBytes("8859_1"));
            return i2;
        }
        catch (UnsupportedEncodingException e) {
            ByteArrayInputStream byteArrayInputStream = null;
            return byteArrayInputStream;
        }
    }

    private void maybeInstantiateMacro(String ident, Macro macro) throws IOException {
        if (macro.isSimple()) {
            if (macro.isBuiltin()) {
                this.pushTemporaryInput(this.builtinSimpleMacro(ident).getBytes("8859_1"), null);
            } else {
                SimpleMacro smacro = (SimpleMacro)macro;
                byte[] replacementText = smacro.value();
                if (replacementText.length > 0) {
                    this.MacroTable.remove(macro.name());
                    this.pushTemporaryInput(replacementText, macro);
                }
            }
            return;
        }
        this.CurrentMacro = (FunctionalMacro)macro;
        byte b = this.outputOptionalWhitespaceOrComment();
        if (this.Input.Index == this.Input.Length || this.Input.Buffer[this.Input.Index] != 40) {
            this.writeString(ident);
            if (b == 47 || b == 92) {
                this.pushBack(b);
            }
            return;
        }
        ++this.Input.Index;
        this.ParenNestingLevel = 1;
        this.Mode = 1;
        this.MacroArgs.setSize(0);
        this.SubstituteMacros = false;
        if (b == 47 || b == 92) {
            this.pushBack(b);
        }
        this.startMacroArgs();
    }

    private void maybeWarnOfOpenConditionals(ConditionalInfo[] conditionals) {
        if (conditionals == null) {
            return;
        }
        for (int i = 0; i < conditionals.length; ++i) {
            this.directiveWarn("OpenConditional", conditionals[i].Type, conditionals[i].LineNumber);
        }
    }

    private void newLine() throws IOException {
        this._newLine();
        if (this.GenerateLineDirectives && this.ShowAllLines) {
            this.writeString("#line ".concat(String.valueOf(this.Input.LineNumber)));
            this._newLine();
        }
    }

    private OpenStream openFile(String pathName) throws IOException {
        if (pathName == null) {
            return new OpenStream(System.in, this.ER.getMesg("Comp.Stdin"), this.CurrentWorkingDirectory, -1);
        }
        File inputFile = this.Reader.getFile(pathName);
        if (inputFile.exists() && inputFile.canRead()) {
            InputStream inputStream = this.Reader.getInputStream(inputFile);
            ++this.InputDepth;
            String directory = new File(inputFile.getAbsolutePath()).getParent();
            return new OpenStream(inputStream, pathName, directory, (int)inputFile.length());
        }
        return null;
    }

    private boolean outputComment() throws IOException {
        boolean isCStyleComment;
        byte chr;
        long startingLine;
        block36: {
            block37: {
                startingLine = this.Input.LineNumber;
                ++this.Input.Index;
                do {
                    if (this.Input.Index == this.Input.Length && !this.reload()) {
                        return false;
                    }
                    chr = this.Input.Buffer[this.Input.Index];
                    if (chr == 42) {
                        isCStyleComment = true;
                        ++this.Input.Index;
                        break block36;
                    }
                    if (chr == 47) {
                        isCStyleComment = false;
                        ++this.Input.Index;
                        break block36;
                    }
                    if (chr != 92) break block37;
                } while (this.eliminateLineContinuation());
                return false;
            }
            return false;
        }
        if (this.RetainComments) {
            int n;
            int n2;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n3 = this.Out.I;
                n2 = n3;
                this.Out.I = n3 + 1;
            } else {
                n2 = this.f();
            }
            byArray[n2] = 47;
            byte[] byArray2 = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n4 = this.Out.I;
                n = n4;
                this.Out.I = n4 + 1;
            } else {
                n = this.f();
            }
            byArray2[n] = isCStyleComment ? 42 : 47;
        } else {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n5 = this.Out.I;
                n = n5;
                this.Out.I = n5 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = 32;
        }
        boolean lastCharWasStar = false;
        while (true) {
            if (this.Input.Index == this.Input.Length && !this.reload()) {
                if (isCStyleComment) {
                    this.warn("Comment.unterminated", "".concat(String.valueOf(startingLine)));
                }
                return true;
            }
            chr = this.Input.Buffer[this.Input.Index];
            if (this.startsLineSep(chr)) {
                if (!isCStyleComment) {
                    return true;
                }
                this.processNewline(false);
                continue;
            }
            if (chr == 42) {
                lastCharWasStar = true;
                if (this.RetainComments) {
                    int n;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n6 = this.Out.I;
                        n = n6;
                        this.Out.I = n6 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = 42;
                }
                ++this.Input.Index;
                continue;
            }
            if (chr == 47) {
                ++this.Input.Index;
                if (isCStyleComment && lastCharWasStar) {
                    if (this.RetainComments) {
                        int n;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n7 = this.Out.I;
                            n = n7;
                            this.Out.I = n7 + 1;
                        } else {
                            n = this.f();
                        }
                        byArray[n] = 47;
                    }
                    return true;
                }
                if (this.RetainComments) {
                    int n;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n8 = this.Out.I;
                        n = n8;
                        this.Out.I = n8 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = chr;
                }
                lastCharWasStar = false;
                continue;
            }
            if (chr == 92) {
                if (this.eliminateLineContinuation()) continue;
                if (this.RetainComments) {
                    int n;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n9 = this.Out.I;
                        n = n9;
                        this.Out.I = n9 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = 92;
                }
                lastCharWasStar = false;
                continue;
            }
            if (this.RetainComments) {
                int n;
                byte[] byArray = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n10 = this.Out.I;
                    n = n10;
                    this.Out.I = n10 + 1;
                } else {
                    n = this.f();
                }
                byArray[n] = chr;
            }
            ++this.Input.Index;
            lastCharWasStar = false;
        }
    }

    private void outputEndOfFixedOrFloatingPointLiteral() throws IOException {
        this.outputInteger(10);
        if (this.outputIfPresent('e', 'E')) {
            this.outputIfPresent('+', '-');
            this.outputInteger(10);
            if (this.outputIfPresent('f', 'F')) {
                return;
            }
            this.outputIfPresent('l', 'L');
        } else {
            this.outputIfPresent('d', 'D');
        }
    }

    private void outputIdentifier(byte firstChr) throws IOException {
        int n;
        byte[] byArray = this.Out.Buf;
        if (this.Out.I < this.Out.Len) {
            int n2 = this.Out.I;
            n = n2;
            this.Out.I = n2 + 1;
        } else {
            n = this.f();
        }
        byArray[n] = firstChr;
        ++this.Input.Index;
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte chr = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[chr & 0xFF] == 1 || LexicalTables.IDLCharClass[chr & 0xFF] == 2) {
                int n3;
                byte[] byArray2 = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n4 = this.Out.I;
                    n3 = n4;
                    this.Out.I = n4 + 1;
                } else {
                    n3 = this.f();
                }
                byArray2[n3] = chr;
                ++this.Input.Index;
                continue;
            }
            if (chr != 92) break;
            if (this.eliminateLineContinuation()) continue;
            this.error("LonelyBackslash");
            return;
        }
    }

    private void outputIdentifierInMacroBody(String ident) throws IOException {
        if (this.MacroArgs.contains(ident)) {
            String errMesg;
            String str = this.Out.toString().trim();
            if (!str.equals("") && (errMesg = this.CurrentMacro.addLiteralString(str)) != null) {
                this.error(errMesg);
            }
            this.CurrentMacro.addFormal(this.MacroArgs.indexOf(ident));
        } else {
            this.writeString(ident);
        }
    }

    private boolean outputIfPresent(char chr) throws IOException {
        return this.outputIfPresent(chr, chr);
    }

    private boolean outputIfPresent(char chr1, char chr2) throws IOException {
        if (this.Input.Index == this.Input.Length && !this.reload()) {
            return false;
        }
        if (this.Input.Buffer[this.Input.Index] == chr1 || this.Input.Buffer[this.Input.Index] == chr2) {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = this.Input.Buffer[this.Input.Index++];
            if (this.Input.Index == this.Input.Length) {
                this.reload();
            }
            return true;
        }
        return false;
    }

    private void outputInteger(int base) throws IOException {
        block17: {
            while (true) {
                byte b;
                if (base == 10) {
                    while (this.Input.Index < this.Input.Length && LexicalTables.IDLCharClass[this.Input.Buffer[this.Input.Index] & 0xFF] == 2) {
                        int n;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n2 = this.Out.I;
                            n = n2;
                            this.Out.I = n2 + 1;
                        } else {
                            n = this.f();
                        }
                        byArray[n] = this.Input.Buffer[this.Input.Index++];
                    }
                } else if (base == 8) {
                    while (this.Input.Index < this.Input.Length && LexicalTables.IDLCharClass[(b = this.Input.Buffer[this.Input.Index]) & 0xFF] == 2 && b != 56 && b != 57) {
                        int n;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n3 = this.Out.I;
                            n = n3;
                            this.Out.I = n3 + 1;
                        } else {
                            n = this.f();
                        }
                        byArray[n] = this.Input.Buffer[this.Input.Index++];
                    }
                } else if (base == 16) {
                    while (this.Input.Index < this.Input.Length && (LexicalTables.IDLCharClass[(b = this.Input.Buffer[this.Input.Index]) & 0xFF] == 2 || b >= 97 && b <= 102 || b >= 65 && b <= 70)) {
                        int n;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n4 = this.Out.I;
                            n = n4;
                            this.Out.I = n4 + 1;
                        } else {
                            n = this.f();
                        }
                        byArray[n] = this.Input.Buffer[this.Input.Index++];
                    }
                } else {
                    this.ER.internalError("unknown base for reading numeric literal");
                }
                if (this.Input.Index == this.Input.Length) {
                    if (this.reload()) continue;
                    return;
                }
                if (this.Input.Buffer[this.Input.Index] != 92) break block17;
                if (!this.eliminateLineContinuation()) break;
            }
            this.error("LonelyBackslash");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputNumericLiteral() throws IOException {
        byte firstDigit = this.Input.Buffer[this.Input.Index];
        boolean base10 = false;
        if (firstDigit == 48) {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = 48;
            if (++this.Input.Index == this.Input.Length && !this.reload()) {
                return;
            }
            byte secondChr = this.Input.Buffer[this.Input.Index];
            if (secondChr >= 48 && secondChr <= 55) {
                this.outputInteger(8);
            } else {
                int n3;
                if (secondChr != 120 && secondChr != 88) return;
                ++this.Input.Index;
                byte[] byArray2 = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n4 = this.Out.I;
                    n3 = n4;
                    this.Out.I = n4 + 1;
                } else {
                    n3 = this.f();
                }
                byArray2[n3] = 120;
                this.outputInteger(16);
            }
        } else {
            this.outputInteger(10);
            base10 = true;
        }
        this.outputIfPresent('u', 'U');
        this.outputIfPresent('l', 'L');
        if (!base10) {
            return;
        }
        if (!this.outputIfPresent('.')) return;
        this.outputEndOfFixedOrFloatingPointLiteral();
    }

    private byte outputOptionalWhitespaceOrComment() throws IOException {
        block4: {
            String ret = "";
            while (true) {
                if (this.Input.Index == this.Input.Length && !this.reload()) {
                    return 0;
                }
                byte chr = this.Input.Buffer[this.Input.Index];
                if (LexicalTables.IDLCharClass[chr & 0xFF] == 0) {
                    if (this.outputWhitespace()) continue;
                    return 92;
                }
                if (chr == 47) {
                    if (this.outputComment()) continue;
                    return 47;
                }
                if (chr != 92) break block4;
                if (!this.eliminateLineContinuation()) break;
            }
            return 92;
        }
        return 0;
    }

    private boolean outputStringOrCharacterLiteral(byte delimiter) throws IOException {
        int n;
        String errorName = delimiter == 34 ? "StringLit" : "CharLit";
        boolean pendingBackslash = false;
        byte[] byArray = this.Out.Buf;
        if (this.Out.I < this.Out.Len) {
            int n2 = this.Out.I;
            n = n2;
            this.Out.I = n2 + 1;
        } else {
            n = this.f();
        }
        byArray[n] = this.Input.Buffer[this.Input.Index++];
        while (true) {
            int n3;
            if (this.Input.Index == this.Input.Length && !this.reload()) {
                this.error(String.valueOf(errorName).concat(".EOLN"));
                return false;
            }
            byte chr = this.Input.Buffer[this.Input.Index];
            if (chr == delimiter) {
                int n4;
                if (pendingBackslash) {
                    int n5;
                    int n6;
                    pendingBackslash = false;
                    ++this.Input.Index;
                    byte[] byArray2 = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n7 = this.Out.I;
                        n6 = n7;
                        this.Out.I = n7 + 1;
                    } else {
                        n6 = this.f();
                    }
                    byArray2[n6] = 92;
                    byte[] byArray3 = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n8 = this.Out.I;
                        n5 = n8;
                        this.Out.I = n8 + 1;
                    } else {
                        n5 = this.f();
                    }
                    byArray3[n5] = delimiter;
                    continue;
                }
                byte[] byArray4 = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n9 = this.Out.I;
                    n4 = n9;
                    this.Out.I = n9 + 1;
                } else {
                    n4 = this.f();
                }
                byArray4[n4] = delimiter;
                ++this.Input.Index;
                return true;
            }
            if (chr == 92) {
                this.Input.advance();
                if (pendingBackslash) {
                    int n10;
                    int n11;
                    byte[] byArray5 = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n12 = this.Out.I;
                        n11 = n12;
                        this.Out.I = n12 + 1;
                    } else {
                        n11 = this.f();
                    }
                    byArray5[n11] = 92;
                    byte[] byArray6 = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n13 = this.Out.I;
                        n10 = n13;
                        this.Out.I = n13 + 1;
                    } else {
                        n10 = this.f();
                    }
                    byArray6[n10] = 92;
                    pendingBackslash = false;
                    continue;
                }
                pendingBackslash = true;
                continue;
            }
            if (this.startsLineSep(chr)) {
                this.error(String.valueOf(errorName).concat(".EOLN"));
                return false;
            }
            if (pendingBackslash) {
                int n14;
                byte[] byArray7 = this.Out.Buf;
                if (this.Out.I < this.Out.Len) {
                    int n15 = this.Out.I;
                    n14 = n15;
                    this.Out.I = n15 + 1;
                } else {
                    n14 = this.f();
                }
                byArray7[n14] = 92;
            }
            pendingBackslash = false;
            byte[] byArray8 = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n16 = this.Out.I;
                n3 = n16;
                this.Out.I = n16 + 1;
            } else {
                n3 = this.f();
            }
            byArray8[n3] = chr;
            ++this.Input.Index;
        }
    }

    private void outputThruNewline() throws IOException {
        boolean alreadyWarned = false;
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte chr = this.Input.Buffer[this.Input.Index];
            if (LexicalTables.IDLCharClass[chr & 0xFF] == 0) {
                this.outputWhitespace();
                continue;
            }
            if (chr == 47) {
                if (this.outputComment()) continue;
            } else if (chr == 92) {
                if (this.eliminateLineContinuation()) continue;
                this.directiveError("lonelyBackslash2");
                return;
            }
            if (this.startsLineSep(chr)) {
                this.processNewline(false);
                return;
            }
            if (!alreadyWarned) {
                alreadyWarned = true;
                this.directiveError("extraText");
            }
            ++this.Input.Index;
        }
        return;
    }

    private boolean outputWhitespace() throws IOException {
        block5: {
            int n;
            boolean DidOutput = false;
            ++this.Input.Index;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = 32;
            while (true) {
                if (this.Input.Index < this.Input.Length && LexicalTables.IDLCharClass[this.Input.Buffer[this.Input.Index] & 0xFF] == 0) {
                    ++this.Input.Index;
                    continue;
                }
                if (this.Input.Index == this.Input.Length) {
                    if (this.reload()) continue;
                    return true;
                }
                if (this.Input.Buffer[this.Input.Index] != 92) break block5;
                if (!this.eliminateLineContinuation()) break;
            }
            return false;
        }
        return true;
    }

    private String prepFilename(String fileName) {
        return StringFunctions.prepFilename(fileName);
    }

    public static Result preprocess(IDLppOptions options, String source, BufferReader reader) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        int status = IDLpp.preprocess(options, source, (OutputStream)output, reader, null);
        return new Result(output.toString(), status);
    }

    public static int preprocess(IDLppOptions options, String source, OutputStream output, BufferReader reader, Vector topLevelIncludedFiles) {
        options._ER.setToolName("preprocessor");
        ByteArrayInputStream bootstrap = IDLpp.makeBootstrapStream(options, source);
        IDLpp preprocessor = new IDLpp(System.getProperty("user.dir"), bootstrap, output, options, reader, topLevelIncludedFiles);
        preprocessor.execute();
        return options._ER.getSummary();
    }

    public static int preprocess(IDLppOptions options, Vector files, OutputStream output, BufferReader reader, Vector topLevelIncludedFiles) {
        options._ER.setToolName("preprocessor");
        ByteArrayInputStream bootstrap = IDLpp.makeBootstrapStream(options, files);
        IDLpp preprocessor = new IDLpp(System.getProperty("user.dir"), bootstrap, output, options, reader, topLevelIncludedFiles);
        preprocessor.execute();
        return options._ER.getSummary();
    }

    public static Result preprocessToString(IDLppOptions options, Vector files, BufferReader reader, Vector topLevelIncludedFiles) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        int status = IDLpp.preprocess(options, files, (OutputStream)output, reader, topLevelIncludedFiles);
        return new Result(output.toString(), status);
    }

    private void process() throws IOException {
        block44: {
            block0: while (this.Input.Index != this.Input.Length || this.reload()) {
                byte chr = this.Input.Buffer[this.Input.Index];
                if (LexicalTables.IDLCharClass[chr & 0xFF] == 0) {
                    this.outputWhitespace();
                    continue;
                }
                if (chr == 47) {
                    int n;
                    if (this.outputComment()) continue;
                    byte[] byArray = this.Out.Buf;
                    if (this.Out.I < this.Out.Len) {
                        int n2 = this.Out.I;
                        n = n2;
                        this.Out.I = n2 + 1;
                    } else {
                        n = this.f();
                    }
                    byArray[n] = 47;
                    if (this.Input.Index == this.Input.Length) break;
                    chr = this.Input.Buffer[this.Input.Index];
                } else {
                    if (this.startsLineSep(chr)) {
                        this.processNewline(false);
                        continue;
                    }
                    if (chr == 92) {
                        if (this.eliminateLineContinuation()) continue;
                        this.error("LonelyBackslash");
                    }
                }
                if (chr == 35 && this.processPound(true)) continue;
                while (this.Input.Index != this.Input.Length || this.reload()) {
                    chr = this.Input.Buffer[this.Input.Index];
                    if (LexicalTables.IDLCharClass[chr & 0xFF] == 0) {
                        this.outputWhitespace();
                        continue;
                    }
                    if (LexicalTables.IDLCharClass[chr & 0xFF] == 3) {
                        int n;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n3 = this.Out.I;
                            n = n3;
                            this.Out.I = n3 + 1;
                        } else {
                            n = this.f();
                        }
                        byArray[n] = chr;
                        ++this.Input.Index;
                        continue;
                    }
                    if (chr == 47) {
                        int n;
                        if (this.outputComment()) continue;
                        byte[] byArray = this.Out.Buf;
                        if (this.Out.I < this.Out.Len) {
                            int n4 = this.Out.I;
                            n = n4;
                            this.Out.I = n4 + 1;
                        } else {
                            n = this.f();
                        }
                        byArray[n] = 47;
                        continue;
                    }
                    if (LexicalTables.IDLCharClass[chr & 0xFF] == 1) {
                        if (this.Mode != 2 && !this.MacroHitTable[chr]) {
                            this.outputIdentifier(chr);
                            continue;
                        }
                        String ident = this.gatherIdentifier();
                        if ("L".equals(ident) && this.Input.Index < this.Input.Length && (this.Input.Buffer[this.Input.Index] == 39 || this.Input.Buffer[this.Input.Index] == 34)) {
                            this.writeString("L");
                            continue;
                        }
                        if (this.SubstituteMacros) {
                            if (this.Mode == 2) {
                                this.outputIdentifierInMacroBody(ident);
                                continue;
                            }
                            Macro macro = (Macro)this.MacroTable.get(ident);
                            if (macro != null) {
                                this.maybeInstantiateMacro(ident, macro);
                                continue;
                            }
                        }
                        this.writeString(ident);
                        continue;
                    }
                    if (this.startsLineSep(chr)) {
                        this.processNewline(false);
                        continue block0;
                    }
                    if (LexicalTables.IDLCharClass[chr & 0xFF] == 5) {
                        if (chr == 44) {
                            if (this.Mode == 1 && this.ParenNestingLevel == 1) {
                                this.MacroArgs.addElement(this.Out.toString().trim());
                            } else {
                                int n;
                                byte[] byArray = this.Out.Buf;
                                if (this.Out.I < this.Out.Len) {
                                    int n5 = this.Out.I;
                                    n = n5;
                                    this.Out.I = n5 + 1;
                                } else {
                                    n = this.f();
                                }
                                byArray[n] = chr;
                            }
                            ++this.Input.Index;
                            continue;
                        }
                        if (chr == 40) {
                            if (this.Mode == 1) {
                                ++this.ParenNestingLevel;
                            } else {
                                int n;
                                byte[] byArray = this.Out.Buf;
                                if (this.Out.I < this.Out.Len) {
                                    int n6 = this.Out.I;
                                    n = n6;
                                    this.Out.I = n6 + 1;
                                } else {
                                    n = this.f();
                                }
                                byArray[n] = chr;
                            }
                            ++this.Input.Index;
                            continue;
                        }
                        if (chr == 41) {
                            int n;
                            ++this.Input.Index;
                            if (this.Mode == 1 && this.ParenNestingLevel-- == 1) {
                                this.invokeMacro();
                                continue;
                            }
                            byte[] byArray = this.Out.Buf;
                            if (this.Out.I < this.Out.Len) {
                                int n7 = this.Out.I;
                                n = n7;
                                this.Out.I = n7 + 1;
                            } else {
                                n = this.f();
                            }
                            byArray[n] = chr;
                            continue;
                        }
                        if (chr == 34) {
                            this.outputStringOrCharacterLiteral(chr);
                            continue;
                        }
                        if (chr == 39) {
                            this.outputStringOrCharacterLiteral(chr);
                            continue;
                        }
                        if (chr == 46) {
                            this.processPeriod();
                            continue;
                        }
                        if (chr == 92) {
                            if (this.eliminateLineContinuation()) continue;
                            this.error("LonelyBackslash");
                            continue;
                        }
                        if (chr == 35) {
                            this.processPound(false);
                            continue;
                        }
                        this.ER.internalError("unhandled OTHER class for character ".concat(String.valueOf(this.escChar(chr))));
                        continue;
                    }
                    if (LexicalTables.IDLCharClass[chr & 0xFF] == 2) {
                        this.outputNumericLiteral();
                        continue;
                    }
                    this.handleErrorChar(chr);
                }
                break block0;
            }
            if (this.Input.isTransient()) break block44;
            this.EOFCleanup();
        }
    }

    private void processDefineDirective() throws IOException {
        if (!this.GenerateOutput) {
            this.gatherErrorText();
            return;
        }
        byte b = this.outputOptionalWhitespaceOrComment();
        if (b == 47) {
            this.directiveError("define.malformed", "/".concat(String.valueOf(this.gatherUntilNewline().trim())));
            this.cleanupNewline();
            return;
        }
        if (b == 92) {
            this.directiveError("lonelyBackslash2");
            this.gatherErrorText();
            return;
        }
        if (this.Input.Index == this.Input.Length && !this.reload()) {
            this.directiveError("define.empty");
            return;
        }
        if (LexicalTables.IDLCharClass[this.Input.Buffer[this.Input.Index] & 0xFF] != 1) {
            this.directiveError("define.malformedIdent");
            this.gatherErrorText();
            return;
        }
        String ident = this.gatherIdentifier();
        if (this.Input.Index == this.Input.Length) {
            this.installMacro(new SimpleMacro(ident, this.Input.FileName, this.Input.LineNumber, "".getBytes("8859_1")), true);
        } else if (this.Input.Buffer[this.Input.Index] == 40) {
            this.createFunctionalMacro(ident);
        } else {
            this.createSimpleMacro(ident);
        }
    }

    private void processElIfDirective() throws IOException {
        if (this.Input.conditionalStackEmpty()) {
            this.directiveError("elif.unmatched");
            this.gatherErrorText();
            return;
        }
        this.installMacro(this.BuiltinDefinedMacro, false);
        ConditionalInfo info = this.Input.conditionalStackPop();
        int status = info.Status;
        if (status == 0) {
            String arg = this.stringCopyOfProcessedTextUntilNewline(true).trim();
            if (this.ConstParser.eval(this.ER, arg, this.Input.FileName, this.Input.LineNumber)) {
                status = 2;
            }
            this.cleanupNewline();
        } else if (status == 2) {
            status = 1;
            this.gatherErrorText();
        } else {
            this.gatherErrorText();
        }
        this.updateConditionalStack(info, (byte)status);
        this.MacroTable.remove("defined");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processElseDirective() throws IOException {
        block7: {
            block6: {
                try {
                    if (this.Input.conditionalStackEmpty()) {
                        this.directiveError("else.unmatched");
                        Object var4_1 = null;
                        break block6;
                    }
                    ConditionalInfo info = this.Input.conditionalStackPop();
                    byte status = info.Status;
                    if (status == 0) {
                        status = 2;
                    } else if (status == 2) {
                        status = 1;
                    }
                    this.updateConditionalStack(info, status);
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    this.outputThruNewline();
                    throw throwable;
                }
            }
            this.outputThruNewline();
            return;
        }
        Object var4_2 = null;
        this.outputThruNewline();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEndIfDirective() throws IOException {
        block6: {
            block5: {
                try {
                    if (this.Input.conditionalStackEmpty()) {
                        this.directiveWarn("endif.unmatched");
                        Object var2_1 = null;
                        break block5;
                    }
                    this.Input.conditionalStackPop();
                    if (this.Input.conditionalStackEmpty() || this.Input.conditionalStackPeek() == 2) {
                        this.startGeneratingOutput();
                        break block6;
                    } else {
                        this.stopGeneratingOutput();
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.outputThruNewline();
                    throw throwable;
                }
            }
            this.outputThruNewline();
            return;
        }
        Object var2_2 = null;
        this.outputThruNewline();
    }

    private void processErrorDirective() throws IOException {
        String s = this.stringCopyOfProcessedTextUntilNewline(false);
        if (!this.GenerateOutput) {
            return;
        }
        this.directiveWarn("error", s);
    }

    private void processIfDefDirective(boolean invert) throws IOException {
        String name = this.stringCopyOfProcessedTextUntilNewline(false).trim();
        boolean value = false;
        if (name.length() == 0) {
            if (this.directiveError("ifdef.empty")) {
                this.ER.add("Comp.PP.Directive.conditional.assumedFalse");
            }
        } else if (!IDLpp.isLegalIdent(name)) {
            if (this.directiveError("ifdef.malformedIdent", name)) {
                this.ER.add("Comp.PP.Directive.conditional.assumedFalse");
            }
        } else {
            boolean bl = value = this.MacroTable.get(name) != null;
        }
        if (invert) {
            value = !value;
        }
        this.updateConditionalStack(invert ? "ifndef" : "ifdef", value ? (byte)2 : 0);
    }

    private void processIfDirective() throws IOException {
        this.installMacro(this.BuiltinDefinedMacro, false);
        try {
            String arg = this.stringCopyOfProcessedTextUntilNewline(true).trim();
            byte status = this.ConstParser.eval(this.ER, arg, this.Input.FileName, this.Input.LineNumber) ? (byte)2 : 0;
            this.updateConditionalStack("if", status);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanupNewline();
            this.MacroTable.remove("defined");
            throw throwable;
        }
        this.cleanupNewline();
        this.MacroTable.remove("defined");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processIncludeDirective() throws IOException {
        boolean newlineCheckCompleted;
        block28: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            String filespec = this.stringCopyOfProcessedTextUntilNewline(true).trim();
                                            newlineCheckCompleted = false;
                                            try {
                                                String[] pathnames;
                                                if (!this.GenerateOutput) {
                                                    Object var10_3 = null;
                                                    if (newlineCheckCompleted) return;
                                                    break block20;
                                                }
                                                int len = filespec.length();
                                                if (len == 0) {
                                                    this.directiveError("include.empty");
                                                    break block21;
                                                }
                                                if (len < 3) {
                                                    this.directiveError("include.malformed", filespec);
                                                    break block22;
                                                }
                                                if (filespec.charAt(0) == '\"') {
                                                    if (filespec.charAt(len - 1) != '\"') {
                                                        this.directiveError("include.unterminatedString", filespec.substring(1));
                                                        break block23;
                                                    }
                                                } else if (filespec.charAt(0) == '<') {
                                                    if (filespec.charAt(len - 1) != '>') {
                                                        this.directiveError("include.unterminatedString", filespec.substring(1));
                                                        break block24;
                                                    }
                                                } else {
                                                    this.directiveError("include.malformed", filespec);
                                                    break block25;
                                                }
                                                if ((pathnames = this.fileSpecToPathNames(filespec)).length == 0) {
                                                    this.directiveWarn("include.noDirs");
                                                    break block26;
                                                }
                                                for (int i = 0; i < pathnames.length; ++i) {
                                                    OpenStream openStream = this.openFile(pathnames[i]);
                                                    if (openStream == null) continue;
                                                    if (this.NotifyInclusions) {
                                                        String s = pathnames[i] == null ? "-" : pathnames[i];
                                                        System.out.println(String.valueOf(new StringBuffer("including \"").append(s).append("\"")));
                                                    }
                                                    if (this.InputDepth == (long)2 && this.TopLevelIncludedFiles != null) {
                                                        this.TopLevelIncludedFiles.addElement(filespec.substring(1, len - 1));
                                                    }
                                                    boolean wantsExtraLineSep = !this.cleanupNewline();
                                                    newlineCheckCompleted = true;
                                                    if (this.GenerateLineDirectives) {
                                                        if (wantsExtraLineSep) {
                                                            this.writeString(this.LineSeparator);
                                                        }
                                                        String s = pathnames[i] == null ? "-" : pathnames[i];
                                                        this.writeString(String.valueOf(new StringBuffer("#line 1 \"").append(s).append("\"").append(this.LineSeparator)));
                                                    }
                                                    this.readFrom(openStream);
                                                    break block27;
                                                }
                                                if (this.directiveError("include.cantopen", this.prepFilename(pathnames[0]))) {
                                                    boolean didSkip = false;
                                                    for (int i = 1; i < pathnames.length; ++i) {
                                                        File file;
                                                        if (this._sysInclLoc != null && !didSkip && (file = new File(pathnames[i])).getParent() != null && file.getParent().equals(this._sysInclLoc)) {
                                                            didSkip = true;
                                                            continue;
                                                        }
                                                        this.ER.add("Comp.PP.Directive.include.orthisone", new Object[]{pathnames[i]});
                                                    }
                                                }
                                                break block28;
                                            }
                                            catch (Throwable throwable) {
                                                Object var10_12 = null;
                                                if (newlineCheckCompleted) throw throwable;
                                                this.cleanupNewline();
                                                throw throwable;
                                            }
                                        }
                                        this.cleanupNewline();
                                        return;
                                    }
                                    Object var10_4 = null;
                                    if (newlineCheckCompleted) return;
                                    this.cleanupNewline();
                                    return;
                                }
                                Object var10_5 = null;
                                if (newlineCheckCompleted) return;
                                this.cleanupNewline();
                                return;
                            }
                            Object var10_6 = null;
                            if (newlineCheckCompleted) return;
                            this.cleanupNewline();
                            return;
                        }
                        Object var10_7 = null;
                        if (newlineCheckCompleted) return;
                        this.cleanupNewline();
                        return;
                    }
                    Object var10_8 = null;
                    if (newlineCheckCompleted) return;
                    this.cleanupNewline();
                    return;
                }
                Object var10_9 = null;
                if (newlineCheckCompleted) return;
                this.cleanupNewline();
                return;
            }
            Object var10_10 = null;
            if (newlineCheckCompleted) return;
            this.cleanupNewline();
            return;
        }
        Object var10_11 = null;
        if (newlineCheckCompleted) return;
        this.cleanupNewline();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processLineDirective() throws IOException {
        boolean changedFileName;
        boolean changedLineNumber;
        String newFileName;
        long newLineNumber;
        boolean newlineCheckCompleted;
        block30: {
            block29: {
                block28: {
                    block27: {
                        block25: {
                            block26: {
                                String args = this.stringCopyOfProcessedTextUntilNewline(true).trim();
                                if (!this.GenerateOutput) {
                                    return;
                                }
                                newlineCheckCompleted = false;
                                newLineNumber = this.Input.LineNumber;
                                newFileName = this.Input.FileName;
                                changedLineNumber = false;
                                changedFileName = false;
                                try {
                                    char c;
                                    if (args.length() == 0) {
                                        this.directiveError("line.empty");
                                        Object var12_7 = null;
                                        if (newlineCheckCompleted) break block25;
                                        break block26;
                                    }
                                    String newLine = "";
                                    int i = 0;
                                    if (args.charAt(0) == '-') {
                                        newLine = "-";
                                        i = 1;
                                    }
                                    while (i < args.length() && (c = args.charAt(i)) >= '0' && c <= '9') {
                                        newLine = String.valueOf(newLine).concat(String.valueOf(c));
                                        ++i;
                                    }
                                    if (newLine.equals("")) {
                                        this.directiveError("line.malformed");
                                        break block27;
                                    }
                                    newLineNumber = Long.parseLong(newLine);
                                    changedLineNumber = newLineNumber != this.Input.LineNumber;
                                    args = args.substring(newLine.length());
                                    if ((args = args.trim()).length() > 0) {
                                        if (args.charAt(0) == '\"') {
                                            if (args.charAt(args.length() - 1) != '\"') {
                                                this.directiveError("line.unterminatedString", args);
                                                break block28;
                                            }
                                            changedFileName = !this.Input.FileName.equals(args = args.substring(1, args.length() - 1));
                                            newFileName = args;
                                        } else {
                                            this.directiveError("line.malformed2");
                                            break block29;
                                        }
                                    }
                                    boolean wantsExtraLineSep = !this.cleanupNewline();
                                    newlineCheckCompleted = true;
                                    if (this.RetainLineDirectives && newLineNumber > (long)0 && (changedLineNumber || changedFileName)) {
                                        if (wantsExtraLineSep) {
                                            this.writeString(this.LineSeparator);
                                        }
                                        this.writeString("#line ".concat(String.valueOf(newLineNumber)));
                                        if (changedFileName) {
                                            this.writeString(String.valueOf(new StringBuffer(" \"").append(newFileName).append("\"")));
                                        }
                                        this.writeString(this.LineSeparator);
                                        this.Input.EndedWithLineSep = true;
                                    }
                                    break block30;
                                }
                                catch (Throwable throwable) {
                                    Object var12_12 = null;
                                    if (!newlineCheckCompleted) {
                                        this.cleanupNewline();
                                    }
                                    if (changedLineNumber) {
                                        this.Input.LineNumber = newLineNumber;
                                    }
                                    if (!changedFileName) throw throwable;
                                    this.Input.FileName = newFileName;
                                    throw throwable;
                                }
                            }
                            this.cleanupNewline();
                        }
                        if (changedLineNumber) {
                            this.Input.LineNumber = newLineNumber;
                        }
                        if (!changedFileName) return;
                        this.Input.FileName = newFileName;
                        return;
                    }
                    Object var12_8 = null;
                    if (!newlineCheckCompleted) {
                        this.cleanupNewline();
                    }
                    if (changedLineNumber) {
                        this.Input.LineNumber = newLineNumber;
                    }
                    if (!changedFileName) return;
                    this.Input.FileName = newFileName;
                    return;
                }
                Object var12_9 = null;
                if (!newlineCheckCompleted) {
                    this.cleanupNewline();
                }
                if (changedLineNumber) {
                    this.Input.LineNumber = newLineNumber;
                }
                if (!changedFileName) return;
                this.Input.FileName = newFileName;
                return;
            }
            Object var12_10 = null;
            if (!newlineCheckCompleted) {
                this.cleanupNewline();
            }
            if (changedLineNumber) {
                this.Input.LineNumber = newLineNumber;
            }
            if (!changedFileName) return;
            this.Input.FileName = newFileName;
            return;
        }
        Object var12_11 = null;
        if (!newlineCheckCompleted) {
            this.cleanupNewline();
        }
        if (changedLineNumber) {
            this.Input.LineNumber = newLineNumber;
        }
        if (!changedFileName) return;
        this.Input.FileName = newFileName;
    }

    private void processNewline(boolean continuation) throws IOException {
        int start = 0;
        byte b = this.Input.Buffer[this.Input.Index];
        if (b == this.FirstLineSeparatorChar) {
            ++this.Input.Index;
            start = 1;
        } else if (b == 13) {
            ++this.Input.Index;
        }
        for (int i = start; i < this.LineSeparatorLength && (this.Input.Index != this.Input.Length || this.reload()); ++i) {
            if (this.Input.Buffer[this.Input.Index] != this.LineSeparator.charAt(i)) continue;
            ++this.Input.Index;
        }
        if (this.Input.Index == this.Input.Length && !this.reload()) {
            this.Input.EndedWithLineSep = true;
        }
        ++this.Input.LineNumber;
        ++this.PendingOutputNewlines;
        if (this.GenerateOutput && !continuation && this.Out == this.NormalSink) {
            this.processPendingNewlines();
        }
    }

    private void processPendingNewlines() throws IOException {
        while (this.PendingOutputNewlines > 0L) {
            --this.PendingOutputNewlines;
            this.newLine();
        }
    }

    private void processPeriod() throws IOException {
        int n;
        byte[] byArray = this.Out.Buf;
        if (this.Out.I < this.Out.Len) {
            int n2 = this.Out.I;
            n = n2;
            this.Out.I = n2 + 1;
        } else {
            n = this.f();
        }
        byArray[n] = 46;
        ++this.Input.Index;
        while (this.Input.Index != this.Input.Length || this.reload()) {
            byte chr = this.Input.Buffer[this.Input.Index];
            if (chr == 92) {
                if (this.eliminateLineContinuation()) continue;
                this.error("LonelyBackslash");
                break;
            }
            if (LexicalTables.IDLCharClass[chr & 0xFF] != 2) break;
            this.outputEndOfFixedOrFloatingPointLiteral();
            return;
        }
    }

    private boolean processPound(boolean canBeDirective) throws IOException {
        ++this.Input.Index;
        if (this.Mode == 2) {
            String errMesg;
            String str = this.Out.toString().trim();
            if (!str.equals("") && (errMesg = this.CurrentMacro.addLiteralString(str)) != null) {
                this.error(errMesg);
            }
            if ((errMesg = this.CurrentMacro.processPound()) != null) {
                this.error(errMesg);
            }
            return false;
        }
        if (canBeDirective) {
            this.handleDirective();
            return true;
        }
        this.handleErrorChar((byte)35);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processPragmaDirective() throws IOException {
        String orig = this.stringCopyOfProcessedTextUntilNewline(false);
        String str = orig.trim();
        if (!this.GenerateOutput) {
            return;
        }
        if (!str.startsWith("Inprise ")) {
            this.writeString("#pragma ".concat(String.valueOf(orig)));
            return;
        }
        str = str.substring("Inprise ".length(), str.length());
        if (!(str = str.trim()).startsWith("IDLpp ")) {
            if (str.equals("IDLpp")) {
                this.directiveWarn("pragma.empty");
                return;
            }
            this.writeString("#pragma ".concat(String.valueOf(orig)));
            return;
        }
        str = str.substring("IDLpp ".length(), str.length());
        if ((str = str.trim()).length() > 0 && str.charAt(0) >= 'a' && str.charAt(0) <= 'z') {
            if (str.equals("suppressLinePragmas")) {
                this.GenerateLineDirectives = false;
                return;
            }
            if (str.equals("nosuppressLinePragmas")) {
                this.GenerateLineDirectives = true;
                return;
            }
            if (str.equals("showInclusions")) {
                this.NotifyInclusions = true;
                return;
            }
            if (str.equals("noshowInclusions")) {
                this.NotifyInclusions = false;
                return;
            }
            if (str.equals("retainComments")) {
                this.RetainComments = true;
                return;
            }
            if (str.equals("noretainComments")) {
                this.RetainComments = false;
                return;
            }
            if (str.equals("retainLineDirective")) {
                this.RetainLineDirectives = true;
                return;
            }
            if (str.equals("noretainLineDirectives")) {
                this.RetainLineDirectives = false;
                return;
            }
            if (str.equals("showAllLines")) {
                this.ShowAllLines = true;
                return;
            }
            if (str.equals("noshowAllLines")) {
                this.ShowAllLines = false;
                return;
            }
            if (str.equals("clearIncludePaths")) {
                this.IncludePaths.removeAllElements();
                return;
            }
            if (!str.startsWith("appendToIncludePaths ")) {
                this.directiveError("pragma.unrecognized", str);
                return;
            }
            String arg = str.substring(21, str.length()).trim();
            if (arg.length() == 0) {
                this.directiveError("pragma.missingDirectory");
            }
            if (arg.length() >= 3 && arg.charAt(0) == '\"' && arg.charAt(arg.length() - 1) == '\"') {
                String path = arg.substring(1, arg.length() - 1);
                this.IncludePaths.addElement(path);
                return;
            }
            this.directiveError("pragma.malformedDirectory");
            return;
        }
        this.directiveError("pragma.unrecognized", str);
    }

    private void processUnDefDirective() throws IOException {
        String name = this.stringCopyOfProcessedTextUntilNewline(false).trim();
        if (!this.GenerateOutput) {
            return;
        }
        if (name.length() == 0) {
            this.directiveError("undef.empty");
            return;
        }
        if (!IDLpp.isLegalIdent(name)) {
            this.directiveError("undef.malformedIdent", name);
            return;
        }
        Macro macro = (Macro)this.MacroTable.get(name);
        if (macro == null) {
            this.directiveWarn("undef.pointless", name);
            return;
        }
        if (macro.isBuiltin()) {
            this.directiveWarn("undef.builtin");
            return;
        }
        this.MacroTable.remove(name);
    }

    private void pushBack(byte b) throws IOException {
        this.pushTemporaryInput(new byte[]{b}, null);
    }

    private void pushTemporaryInput(byte[] src, Macro macro) throws IOException {
        this.Out.flush();
        this.Input = new OpenStream(src, this.Input, macro);
    }

    private void readFrom(OpenStream openStream) throws IOException {
        OpenStream savedInput = this.Input;
        this.Input = openStream;
        try {
            this.Out.flush();
            this.SavedInputDepth = this.InputDepth--;
            this.process();
            this.maybeWarnOfOpenConditionals(this.Input.openConditionals());
            this.SavedInputDepth = -1L;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.Input.finished();
            --this.InputDepth;
            boolean wantsExtraLineSep = !this.Input.EndedWithLineSep;
            this.Input = savedInput;
            if (this.GenerateLineDirectives && !this.Input.FileName.equals("")) {
                if (wantsExtraLineSep) {
                    this.writeString(this.LineSeparator);
                }
                this.writeString(String.valueOf(new StringBuffer("#line ").append(Long.toString(this.Input.LineNumber)).append(" \"").append(this.Input.FileName).append("\"").append(this.LineSeparator)));
                this.Input.EndedWithLineSep = true;
            }
            throw throwable;
        }
        this.Input.finished();
        boolean wantsExtraLineSep = !this.Input.EndedWithLineSep;
        this.Input = savedInput;
        if (this.GenerateLineDirectives && !this.Input.FileName.equals("")) {
            if (wantsExtraLineSep) {
                this.writeString(this.LineSeparator);
            }
            this.writeString(String.valueOf(new StringBuffer("#line ").append(Long.toString(this.Input.LineNumber)).append(" \"").append(this.Input.FileName).append("\"").append(this.LineSeparator)));
            this.Input.EndedWithLineSep = true;
        }
    }

    private boolean reload() throws IOException {
        if (this.Out == this.OneLineSink) {
            if (this.Input.reload()) {
                this.ER.internalError("shouldn't be able to reload when collecting output in OneLineSink.");
            }
            return false;
        }
        this.Out.flush();
        if (this.Input.reload()) {
            return this.Input.Index < this.Input.Length ? true : this.reload();
        }
        if (this.Input.PreviousStream != null) {
            if (this.Input.Macro != null) {
                this.installMacro(this.Input.Macro, false);
            }
            this.Input = this.Input.PreviousStream;
            return this.Input.Index < this.Input.Length ? true : this.reload();
        }
        return false;
    }

    private void startGeneratingOutput() throws IOException {
        if (this.GenerateOutput) {
            return;
        }
        this.Out.reset();
        this.Out.Ignore = false;
        this.GenerateOutput = true;
        this.processPendingNewlines();
    }

    private void startLineGather() {
        this.Out = this.OneLineSink;
    }

    private void startMacroArgs() {
        this.PreviousSink = this.Out;
        this.Out = this.MacroArgSink;
    }

    private boolean startsLineSep(byte chr) {
        return chr == this.FirstLineSeparatorChar || chr == 10 || chr == 13;
    }

    private void stopGeneratingOutput() throws IOException {
        if (!this.GenerateOutput) {
            return;
        }
        this.processPendingNewlines();
        this.Out.flush();
        this.Out.Ignore = true;
        this.GenerateOutput = false;
    }

    private void stopLineGather() {
        this.Out = this.NormalSink;
    }

    private void stopMacroArgs() {
        this.Out = this.PreviousSink;
    }

    private String stringCopyOfProcessedTextUntilNewline(boolean substituteMacros) throws IOException {
        String rawBody = this.gatherUntilNewline();
        if (rawBody.length() == 0) {
            return rawBody;
        }
        this.startLineGather();
        if (!substituteMacros) {
            this.SubstituteMacros = false;
        }
        OpenStream savedInput = this.Input;
        this.Input = new OpenStream(rawBody.getBytes("8859_1"), this.Input, null);
        this.process();
        this.Input = savedInput;
        String ret = this.Out.toString();
        this.stopLineGather();
        if (!substituteMacros) {
            this.SubstituteMacros = true;
        }
        return ret;
    }

    private void updateConditionalStack(ConditionalInfo info, byte newStatus) throws IOException {
        if (this.Input.updateConditionalStack(info, newStatus)) {
            this.startGeneratingOutput();
        } else {
            this.stopGeneratingOutput();
        }
    }

    private void updateConditionalStack(String type, byte newStatus) throws IOException {
        if (this.Input.updateConditionalStack(type, newStatus)) {
            this.startGeneratingOutput();
        } else {
            this.stopGeneratingOutput();
        }
    }

    private boolean warn(String mesg) {
        return this.ER.warn("Comp.PP.".concat(String.valueOf(mesg)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber);
    }

    private boolean warn(String mesg, String arg) {
        return this.ER.warn("Comp.PP.".concat(String.valueOf(mesg)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, arg);
    }

    private boolean warn(String mesgName, String refName, long lineNumber) {
        return this.ER.warn2("Comp.PP.".concat(String.valueOf(mesgName)), this.ER.setFile(this.Input.FileName), this.Input.LineNumber, "Comp.PP.".concat(String.valueOf(refName)), this.ER.setFile(this.Input.FileName), lineNumber);
    }

    private void writeString(String str) throws IOException {
        for (int i = 0; i < str.length(); ++i) {
            int n;
            byte[] byArray = this.Out.Buf;
            if (this.Out.I < this.Out.Len) {
                int n2 = this.Out.I;
                n = n2;
                this.Out.I = n2 + 1;
            } else {
                n = this.f();
            }
            byArray[n] = (byte)str.charAt(i);
        }
    }

    public static final class Result {
        public String _output;
        public int _status;

        public Result(String output, int status) {
            this._output = output;
            this._status = status;
        }
    }

    class Sink {
        OutputStream Stream;
        byte[] Buf;
        int I;
        int Len;
        private boolean Temporary;
        boolean Ignore = false;

        Sink(OutputStream stream) {
            this.Stream = stream;
            this.Len = 0x119999;
            this.Buf = new byte[this.Len];
            this.I = 0;
            this.Temporary = false;
        }

        Sink() {
            this.Stream = new ByteArrayOutputStream();
            this.Len = 256;
            this.Buf = new byte[this.Len];
            this.I = 0;
            this.Temporary = true;
        }

        int flush() throws IOException {
            if (!this.Ignore) {
                this.Stream.write(this.Buf, 0, this.I);
            }
            this.I = 0;
            return 0;
        }

        void reset() {
            this.I = 0;
            if (this.Temporary) {
                ((ByteArrayOutputStream)this.Stream).reset();
            }
        }

        public String toString() {
            if (this.Ignore) {
                this.reset();
                return "";
            }
            if (this.Temporary) {
                ByteArrayOutputStream stream = (ByteArrayOutputStream)this.Stream;
                String ret = null;
                if (stream.size() > 0) {
                    try {
                        this.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        ret = stream.toString("8859_1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    stream.reset();
                } else {
                    try {
                        ret = new String(this.Buf, 0, this.I, "8859_1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.I = 0;
                }
                return ret;
            }
            IDLpp.this.ER.internalError("attempted to call toString() on a real output Sink instance");
            return null;
        }

        byte[] toByteArray() {
            if (this.Ignore) {
                this.reset();
                return new byte[0];
            }
            if (this.Temporary) {
                byte[] ret;
                ByteArrayOutputStream stream = (ByteArrayOutputStream)this.Stream;
                if (stream.size() > 0) {
                    try {
                        this.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ret = stream.toByteArray();
                    stream.reset();
                } else {
                    ret = new byte[this.I];
                    System.arraycopy(this.Buf, 0, ret, 0, this.I);
                    this.I = 0;
                }
                return ret;
            }
            IDLpp.this.ER.internalError("attempted to call toString() on a real output Sink instance");
            return null;
        }
    }
}

